export default function Home() {
  return (
    <div className="min-h-screen bg-white">
      {/* Hero Section */}
      <div className="bg-gradient-to-br from-slate-900 via-slate-800 to-slate-900 text-white">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-20">
          <div className="text-center">
            <h1 className="text-5xl md:text-6xl font-bold mb-6 leading-tight">
              Take Control of Your
              <span className="block text-emerald-400">Financial Future</span>
            </h1>
            <p className="text-xl md:text-2xl text-slate-300 mb-8 max-w-3xl mx-auto leading-relaxed">
              In today's uncertain economy, smart financial decisions aren't just important—they're essential. Discover trusted partners who can help you grow, protect, and optimize your wealth.
            </p>

            {/* Hero CTA Buttons */}
            <div className="flex flex-col sm:flex-row gap-4 justify-center items-center mb-12">
              <a
                href="#partners"
                className="bg-emerald-500 hover:bg-emerald-600 text-white px-8 py-4 rounded-lg font-semibold text-lg transition-all duration-300 shadow-lg hover:shadow-xl hover:scale-105 flex items-center gap-2"
              >
                Compare Loan Offers
                <svg className="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                  <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M13 7l5 5m0 0l-5 5m5-5H6" />
                </svg>
              </a>
              <a
                href="#testimonials"
                className="bg-white/10 hover:bg-white/20 backdrop-blur-sm text-white px-8 py-4 rounded-lg font-semibold text-lg transition-all duration-300 border-2 border-white/30 hover:border-white/50"
              >
                See Customer Reviews
              </a>
            </div>

            {/* Trust Indicators */}
            <div className="flex flex-wrap justify-center gap-6 mb-12 text-sm text-slate-300">
              <div className="flex items-center gap-2">
                <svg className="w-5 h-5 text-emerald-400" fill="currentColor" viewBox="0 0 20 20">
                  <path fillRule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clipRule="evenodd" />
                </svg>
                <span>Fast Approval</span>
              </div>
              <div className="flex items-center gap-2">
                <svg className="w-5 h-5 text-emerald-400" fill="currentColor" viewBox="0 0 20 20">
                  <path fillRule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clipRule="evenodd" />
                </svg>
                <span>Bad Credit OK</span>
              </div>
              <div className="flex items-center gap-2">
                <svg className="w-5 h-5 text-emerald-400" fill="currentColor" viewBox="0 0 20 20">
                  <path fillRule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clipRule="evenodd" />
                </svg>
                <span>Same-Day Funding</span>
              </div>
              <div className="flex items-center gap-2">
                <svg className="w-5 h-5 text-emerald-400" fill="currentColor" viewBox="0 0 20 20">
                  <path fillRule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clipRule="evenodd" />
                </svg>
                <span>100% Secure</span>
              </div>
            </div>

            {/* Feature Cards */}
            <div className="grid md:grid-cols-3 gap-8 mt-16">
              <div className="flex flex-col items-center">
                <div className="mb-4">
                  <svg className="w-12 h-12 text-emerald-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M13 7h8m0 0v8m0-8l-8 8-4-4-6 6" />
                  </svg>
                </div>
                <h3 className="text-lg font-semibold mb-2">Grow Your Wealth</h3>
                <p className="text-slate-400 text-sm">Smart investment strategies for every goal</p>
              </div>

              <div className="flex flex-col items-center">
                <div className="mb-4">
                  <svg className="w-12 h-12 text-emerald-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z" />
                  </svg>
                </div>
                <h3 className="text-lg font-semibold mb-2">Protect Your Assets</h3>
                <p className="text-slate-400 text-sm">Security and insurance that works for you</p>
              </div>

              <div className="flex flex-col items-center">
                <div className="mb-4">
                  <svg className="w-12 h-12 text-emerald-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M9 12l2 2 4-4M7.835 4.697a3.42 3.42 0 001.946-.806 3.42 3.42 0 014.438 0 3.42 3.42 0 001.946.806 3.42 3.42 0 013.138 3.138 3.42 3.42 0 00.806 1.946 3.42 3.42 0 010 4.438 3.42 3.42 0 00-.806 1.946 3.42 3.42 0 01-3.138 3.138 3.42 3.42 0 00-1.946.806 3.42 3.42 0 01-4.438 0 3.42 3.42 0 00-1.946-.806 3.42 3.42 0 01-3.138-3.138 3.42 3.42 0 00-.806-1.946 3.42 3.42 0 010-4.438 3.42 3.42 0 00.806-1.946 3.42 3.42 0 013.138-3.138z" />
                  </svg>
                </div>
                <h3 className="text-lg font-semibold mb-2">Expert Guidance</h3>
                <p className="text-slate-400 text-sm">Trusted advisors with proven track records</p>
              </div>
            </div>
          </div>
        </div>
      </div>

      {/* Featured Partners Section */}
      <div id="partners" className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-20">
        <div className="text-center mb-16 relative">
          <h2 className="text-4xl font-bold text-slate-900 mb-4">Featured Financial Partners</h2>
          <p className="text-xl text-slate-600 max-w-3xl mx-auto">
            We've partnered with industry-leading companies to bring you exclusive offers and competitive rates you won't find anywhere else.
          </p>
        </div>

        <div className="space-y-8">
          {/* Wizzay - Green */}
          <div className="border-2 border-emerald-200 rounded-2xl overflow-hidden hover:shadow-xl transition-shadow duration-300">
            {/* Hero Image */}
            <div className="relative h-48 overflow-hidden">
              <img
                src="https://images.unsplash.com/photo-1561414927-6d86591d0c4f?w=800&auto=format&fit=crop&q=80"
                alt="Fast Online Loans"
                className="w-full h-full object-cover"
              />
              <div className="absolute inset-0 bg-gradient-to-t from-emerald-900/60 to-transparent"></div>
            </div>
            <div className="bg-emerald-50 p-8">
              <div className="flex items-start justify-between mb-6">
                <div className="flex items-center gap-4">
                  <div className="w-12 h-12 bg-emerald-100 rounded-lg flex items-center justify-center">
                    <svg className="w-6 h-6 text-emerald-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                      <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z" />
                    </svg>
                  </div>
                  <div>
                    <h3 className="text-2xl font-bold text-slate-900">Wizzay</h3>
                    <p className="text-sm font-medium text-emerald-600">Fast Online Loans</p>
                  </div>
                </div>
                <div className="flex items-center gap-1 bg-white px-3 py-1.5 rounded-full">
                  <svg className="w-4 h-4 text-amber-400 fill-current" viewBox="0 0 20 20">
                    <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z" />
                  </svg>
                  <span className="font-semibold text-slate-900">4.9</span>
                </div>
              </div>
              <p className="text-slate-700 text-lg leading-relaxed mb-6">
                Get quick access to funds with Wizzay's streamlined loan application process. Our flexible lending solutions are designed to meet your financial needs with competitive rates and fast approval times.
              </p>
              <div className="grid md:grid-cols-2 gap-3 mb-6">
                <div className="flex items-start gap-2">
                  <div className="text-emerald-600 mt-0.5">✓</div>
                  <span className="text-slate-700">Quick approval process</span>
                </div>
                <div className="flex items-start gap-2">
                  <div className="text-emerald-600 mt-0.5">✓</div>
                  <span className="text-slate-700">Flexible loan amounts</span>
                </div>
                <div className="flex items-start gap-2">
                  <div className="text-emerald-600 mt-0.5">✓</div>
                  <span className="text-slate-700">Competitive interest rates</span>
                </div>
                <div className="flex items-start gap-2">
                  <div className="text-emerald-600 mt-0.5">✓</div>
                  <span className="text-slate-700">Transparent terms</span>
                </div>
              </div>
              <a
                href="https://tds.pdl-profit.com/h/1tkr68fe79f76feb5"
                target="_blank"
                rel="noopener noreferrer"
                className="bg-emerald-600 hover:bg-emerald-700 text-white px-8 py-4 rounded-lg font-semibold text-lg flex items-center gap-2 hover:gap-3 transition-all duration-300 shadow-lg inline-block"
              >
                Apply Now
                <svg className="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                  <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M9 5l7 7-7 7" />
                </svg>
              </a>
            </div>
          </div>

          {/* Your Payday - Blue */}
          <div className="border-2 border-blue-200 rounded-2xl overflow-hidden hover:shadow-xl transition-shadow duration-300">
            {/* Hero Image */}
            <div className="relative h-48 overflow-hidden">
              <img
                src="https://images.unsplash.com/photo-1633158829585-23ba8f7c8caf?w=800&auto=format&fit=crop&q=80"
                alt="Payday Loan Solutions"
                className="w-full h-full object-cover"
              />
              <div className="absolute inset-0 bg-gradient-to-t from-blue-900/60 to-transparent"></div>
            </div>
            <div className="bg-blue-50 p-8">
              <div className="flex items-start justify-between mb-6">
                <div className="flex items-center gap-4">
                  <div className="w-12 h-12 bg-blue-100 rounded-lg flex items-center justify-center">
                    <svg className="w-6 h-6 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                      <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M17 9V7a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2m2 4h10a2 2 0 002-2v-6a2 2 0 00-2-2H9a2 2 0 00-2 2v6a2 2 0 002 2zm7-5a2 2 0 11-4 0 2 2 0 014 0z" />
                    </svg>
                  </div>
                  <div>
                    <h3 className="text-2xl font-bold text-slate-900">Your Payday</h3>
                    <p className="text-sm font-medium text-blue-600">Payday Loan Solutions</p>
                  </div>
                </div>
                <div className="flex items-center gap-1 bg-white px-3 py-1.5 rounded-full">
                  <svg className="w-4 h-4 text-amber-400 fill-current" viewBox="0 0 20 20">
                    <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z" />
                  </svg>
                  <span className="font-semibold text-slate-900">4.8</span>
                </div>
              </div>
              <p className="text-slate-700 text-lg leading-relaxed mb-6">
                Your Payday provides accessible short-term lending solutions designed to help you manage unexpected expenses. Simple application, fast funding, and straightforward repayment terms.
              </p>
              <div className="grid md:grid-cols-2 gap-3 mb-6">
                <div className="flex items-start gap-2">
                  <div className="text-blue-600 mt-0.5">✓</div>
                  <span className="text-slate-700">Same-day funding available</span>
                </div>
                <div className="flex items-start gap-2">
                  <div className="text-blue-600 mt-0.5">✓</div>
                  <span className="text-slate-700">Simple online application</span>
                </div>
                <div className="flex items-start gap-2">
                  <div className="text-blue-600 mt-0.5">✓</div>
                  <span className="text-slate-700">Flexible repayment options</span>
                </div>
                <div className="flex items-start gap-2">
                  <div className="text-blue-600 mt-0.5">✓</div>
                  <span className="text-slate-700">Bad credit welcome</span>
                </div>
              </div>
              <a
                href="https://tds.pdl-profit.com/h/1tif68f69ef837914"
                target="_blank"
                rel="noopener noreferrer"
                className="bg-blue-600 hover:bg-blue-700 text-white px-8 py-4 rounded-lg font-semibold text-lg flex items-center gap-2 hover:gap-3 transition-all duration-300 shadow-lg inline-block"
              >
                Get Funds Fast
                <svg className="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                  <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M9 5l7 7-7 7" />
                </svg>
              </a>
            </div>
          </div>

          {/* Vita Payday - Amber */}
          <div className="border-2 border-amber-200 rounded-2xl overflow-hidden hover:shadow-xl transition-shadow duration-300">
            {/* Hero Image */}
            <div className="relative h-48 overflow-hidden">
              <img
                src="https://images.unsplash.com/photo-1607863680198-23d4b2565df0?w=800&auto=format&fit=crop&q=80"
                alt="Emergency Cash Loans"
                className="w-full h-full object-cover"
              />
              <div className="absolute inset-0 bg-gradient-to-t from-amber-900/60 to-transparent"></div>
            </div>
            <div className="bg-amber-50 p-8">
              <div className="flex items-start justify-between mb-6">
                <div className="flex items-center gap-4">
                  <div className="w-12 h-12 bg-amber-100 rounded-lg flex items-center justify-center">
                    <svg className="w-6 h-6 text-amber-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                      <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M13 7h8m0 0v8m0-8l-8 8-4-4-6 6" />
                    </svg>
                  </div>
                  <div>
                    <h3 className="text-2xl font-bold text-slate-900">Vita Payday</h3>
                    <p className="text-sm font-medium text-amber-600">Emergency Cash Loans</p>
                  </div>
                </div>
                <div className="flex items-center gap-1 bg-white px-3 py-1.5 rounded-full">
                  <svg className="w-4 h-4 text-amber-400 fill-current" viewBox="0 0 20 20">
                    <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z" />
                  </svg>
                  <span className="font-semibold text-slate-900">4.9</span>
                </div>
              </div>
              <p className="text-slate-700 text-lg leading-relaxed mb-6">
                Vita Payday offers quick emergency loans for those unexpected financial challenges. With minimal requirements and rapid processing, get the cash you need when you need it most.
              </p>
              <div className="grid md:grid-cols-2 gap-3 mb-6">
                <div className="flex items-start gap-2">
                  <div className="text-amber-600 mt-0.5">✓</div>
                  <span className="text-slate-700">No credit check required</span>
                </div>
                <div className="flex items-start gap-2">
                  <div className="text-amber-600 mt-0.5">✓</div>
                  <span className="text-slate-700">Instant decision</span>
                </div>
                <div className="flex items-start gap-2">
                  <div className="text-amber-600 mt-0.5">✓</div>
                  <span className="text-slate-700">Direct deposit available</span>
                </div>
                <div className="flex items-start gap-2">
                  <div className="text-amber-600 mt-0.5">✓</div>
                  <span className="text-slate-700">Easy online process</span>
                </div>
              </div>
              <a
                href="https://tds.pdl-profit.com/h/1ti168fe7a402782f"
                target="_blank"
                rel="noopener noreferrer"
                className="bg-amber-600 hover:bg-amber-700 text-white px-8 py-4 rounded-lg font-semibold text-lg flex items-center gap-2 hover:gap-3 transition-all duration-300 shadow-lg inline-block"
              >
                Borrow Now
                <svg className="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                  <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M9 5l7 7-7 7" />
                </svg>
              </a>
            </div>
          </div>

          {/* Payday.com - Violet */}
          <div className="border-2 border-violet-200 rounded-2xl overflow-hidden hover:shadow-xl transition-shadow duration-300">
            {/* Hero Image */}
            <div className="relative h-48 overflow-hidden">
              <img
                src="https://images.unsplash.com/photo-1450101499163-c8848c66ca85?w=800&auto=format&fit=crop&q=80"
                alt="Personal Loan Network"
                className="w-full h-full object-cover"
              />
              <div className="absolute inset-0 bg-gradient-to-t from-violet-900/60 to-transparent"></div>
            </div>
            <div className="bg-violet-50 p-8">
              <div className="flex items-start justify-between mb-6">
                <div className="flex items-center gap-4">
                  <div className="w-12 h-12 bg-violet-100 rounded-lg flex items-center justify-center">
                    <svg className="w-6 h-6 text-violet-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                      <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M21 13.255A23.931 23.931 0 0112 15c-3.183 0-6.22-.62-9-1.745M16 6V4a2 2 0 00-2-2h-4a2 2 0 00-2 2v2m4 6h.01M5 20h14a2 2 0 002-2V8a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z" />
                    </svg>
                  </div>
                  <div>
                    <h3 className="text-2xl font-bold text-slate-900">Payday.com</h3>
                    <p className="text-sm font-medium text-violet-600">Personal Loan Network</p>
                  </div>
                </div>
                <div className="flex items-center gap-1 bg-white px-3 py-1.5 rounded-full">
                  <svg className="w-4 h-4 text-amber-400 fill-current" viewBox="0 0 20 20">
                    <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z" />
                  </svg>
                  <span className="font-semibold text-slate-900">4.7</span>
                </div>
              </div>
              <p className="text-slate-700 text-lg leading-relaxed mb-6">
                Payday.com connects you with trusted lenders offering personal loans tailored to your needs. Quick matching process with multiple loan options to choose from.
              </p>
              <div className="grid md:grid-cols-2 gap-3 mb-6">
                <div className="flex items-start gap-2">
                  <div className="text-violet-600 mt-0.5">✓</div>
                  <span className="text-slate-700">Multiple lender options</span>
                </div>
                <div className="flex items-start gap-2">
                  <div className="text-violet-600 mt-0.5">✓</div>
                  <span className="text-slate-700">Fast quote comparison</span>
                </div>
                <div className="flex items-start gap-2">
                  <div className="text-violet-600 mt-0.5">✓</div>
                  <span className="text-slate-700">Transparent pricing</span>
                </div>
                <div className="flex items-start gap-2">
                  <div className="text-violet-600 mt-0.5">✓</div>
                  <span className="text-slate-700">Secure process</span>
                </div>
              </div>
              <a
                href="https://tds.pdl-profit.com/h/1thj68f460f272691"
                target="_blank"
                rel="noopener noreferrer"
                className="bg-violet-600 hover:bg-violet-700 text-white px-8 py-4 rounded-lg font-semibold text-lg flex items-center gap-2 hover:gap-3 transition-all duration-300 shadow-lg inline-block"
              >
                Find Your Loan
                <svg className="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                  <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M9 5l7 7-7 7" />
                </svg>
              </a>
            </div>
          </div>

          {/* 247 Fast Funds - Rose */}
          <div className="border-2 border-rose-200 rounded-2xl overflow-hidden hover:shadow-xl transition-shadow duration-300">
            {/* Hero Image */}
            <div className="relative h-48 overflow-hidden">
              <img
                src="https://images.unsplash.com/photo-1526304640581-d334cdbbf45e?w=800&auto=format&fit=crop&q=80"
                alt="24/7 Emergency Loans"
                className="w-full h-full object-cover"
              />
              <div className="absolute inset-0 bg-gradient-to-t from-rose-900/60 to-transparent"></div>
            </div>
            <div className="bg-rose-50 p-8">
              <div className="flex items-start justify-between mb-6">
                <div className="flex items-center gap-4">
                  <div className="w-12 h-12 bg-rose-100 rounded-lg flex items-center justify-center">
                    <svg className="w-6 h-6 text-rose-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                      <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M3 10h18M7 15h1m4 0h1m-7 4h12a3 3 0 003-3V8a3 3 0 00-3-3H6a3 3 0 00-3 3v8a3 3 0 003 3z" />
                    </svg>
                  </div>
                  <div>
                    <h3 className="text-2xl font-bold text-slate-900">247 Fast Funds</h3>
                    <p className="text-sm font-medium text-rose-600">24/7 Emergency Loans</p>
                  </div>
                </div>
                <div className="flex items-center gap-1 bg-white px-3 py-1.5 rounded-full">
                  <svg className="w-4 h-4 text-amber-400 fill-current" viewBox="0 0 20 20">
                    <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z" />
                  </svg>
                  <span className="font-semibold text-slate-900">4.8</span>
                </div>
              </div>
              <p className="text-slate-700 text-lg leading-relaxed mb-6">
                247 Fast Funds provides round-the-clock access to emergency loans when you need them. Our 24/7 service ensures you can apply anytime and get rapid funding whenever life happens.
              </p>
              <div className="grid md:grid-cols-2 gap-3 mb-6">
                <div className="flex items-start gap-2">
                  <div className="text-rose-600 mt-0.5">✓</div>
                  <span className="text-slate-700">Available 24/7</span>
                </div>
                <div className="flex items-start gap-2">
                  <div className="text-rose-600 mt-0.5">✓</div>
                  <span className="text-slate-700">Rapid approval</span>
                </div>
                <div className="flex items-start gap-2">
                  <div className="text-rose-600 mt-0.5">✓</div>
                  <span className="text-slate-700">Minimal documentation</span>
                </div>
                <div className="flex items-start gap-2">
                  <div className="text-rose-600 mt-0.5">✓</div>
                  <span className="text-slate-700">Instant transfers</span>
                </div>
              </div>
              <a
                href="https://tds.pdl-profit.com/h/1t5a68fe8958b87e7"
                target="_blank"
                rel="noopener noreferrer"
                className="bg-rose-600 hover:bg-rose-700 text-white px-8 py-4 rounded-lg font-semibold text-lg flex items-center gap-2 hover:gap-3 transition-all duration-300 shadow-lg inline-block"
              >
                Get Cash Today
                <svg className="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                  <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M9 5l7 7-7 7" />
                </svg>
              </a>
            </div>
          </div>
        </div>

        {/* Customer Testimonials Section */}
        <div id="testimonials" className="mt-24">
          <div className="text-center mb-12">
            <h2 className="text-4xl font-bold text-slate-900 mb-4">What Our Customers Say</h2>
            <p className="text-xl text-slate-600 max-w-3xl mx-auto">
              Don't just take our word for it. Here's what real customers have to say about their experience.
            </p>
          </div>

          <div className="grid md:grid-cols-3 gap-8">
            {/* Testimonial 1 */}
            <div className="bg-white p-8 rounded-2xl shadow-lg border border-slate-100 hover:shadow-xl transition-shadow duration-300">
              <div className="flex items-center gap-1 mb-4">
                {[...Array(5)].map((_, i) => (
                  <svg key={i} className="w-5 h-5 text-amber-400 fill-current" viewBox="0 0 20 20">
                    <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z" />
                  </svg>
                ))}
              </div>
              <p className="text-slate-700 mb-6 leading-relaxed">
                "I needed emergency cash for car repairs and got approved within hours. The process was incredibly easy and the funds were in my account the same day. Highly recommend!"
              </p>
              <div className="flex items-center gap-3">
                <div className="w-12 h-12 bg-emerald-100 rounded-full flex items-center justify-center">
                  <span className="text-emerald-700 font-semibold text-lg">JM</span>
                </div>
                <div>
                  <p className="font-semibold text-slate-900">Jennifer Martinez</p>
                  <p className="text-sm text-slate-500">Phoenix, AZ</p>
                </div>
              </div>
            </div>

            {/* Testimonial 2 */}
            <div className="bg-white p-8 rounded-2xl shadow-lg border border-slate-100 hover:shadow-xl transition-shadow duration-300">
              <div className="flex items-center gap-1 mb-4">
                {[...Array(5)].map((_, i) => (
                  <svg key={i} className="w-5 h-5 text-amber-400 fill-current" viewBox="0 0 20 20">
                    <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z" />
                  </svg>
                ))}
              </div>
              <p className="text-slate-700 mb-6 leading-relaxed">
                "Even with bad credit, I was able to get the loan I needed. The transparent terms and no hidden fees made me feel comfortable throughout the entire process."
              </p>
              <div className="flex items-center gap-3">
                <div className="w-12 h-12 bg-blue-100 rounded-full flex items-center justify-center">
                  <span className="text-blue-700 font-semibold text-lg">RC</span>
                </div>
                <div>
                  <p className="font-semibold text-slate-900">Robert Chen</p>
                  <p className="text-sm text-slate-500">Seattle, WA</p>
                </div>
              </div>
            </div>

            {/* Testimonial 3 */}
            <div className="bg-white p-8 rounded-2xl shadow-lg border border-slate-100 hover:shadow-xl transition-shadow duration-300">
              <div className="flex items-center gap-1 mb-4">
                {[...Array(5)].map((_, i) => (
                  <svg key={i} className="w-5 h-5 text-amber-400 fill-current" viewBox="0 0 20 20">
                    <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z" />
                  </svg>
                ))}
              </div>
              <p className="text-slate-700 mb-6 leading-relaxed">
                "Fast, simple, and reliable. I've used this service twice now for unexpected expenses, and both times the experience was smooth. Great customer service too!"
              </p>
              <div className="flex items-center gap-3">
                <div className="w-12 h-12 bg-violet-100 rounded-full flex items-center justify-center">
                  <span className="text-violet-700 font-semibold text-lg">ST</span>
                </div>
                <div>
                  <p className="font-semibold text-slate-900">Sarah Thompson</p>
                  <p className="text-sm text-slate-500">Austin, TX</p>
                </div>
              </div>
            </div>

            {/* Testimonial 4 */}
            <div className="bg-white p-8 rounded-2xl shadow-lg border border-slate-100 hover:shadow-xl transition-shadow duration-300">
              <div className="flex items-center gap-1 mb-4">
                {[...Array(5)].map((_, i) => (
                  <svg key={i} className="w-5 h-5 text-amber-400 fill-current" viewBox="0 0 20 20">
                    <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z" />
                  </svg>
                ))}
              </div>
              <p className="text-slate-700 mb-6 leading-relaxed">
                "The 24/7 availability was a lifesaver. I applied late at night and had everything sorted by morning. No hassle, no endless paperwork. Just what I needed."
              </p>
              <div className="flex items-center gap-3">
                <div className="w-12 h-12 bg-amber-100 rounded-full flex items-center justify-center">
                  <span className="text-amber-700 font-semibold text-lg">MP</span>
                </div>
                <div>
                  <p className="font-semibold text-slate-900">Michael Peterson</p>
                  <p className="text-sm text-slate-500">Denver, CO</p>
                </div>
              </div>
            </div>

            {/* Testimonial 5 */}
            <div className="bg-white p-8 rounded-2xl shadow-lg border border-slate-100 hover:shadow-xl transition-shadow duration-300">
              <div className="flex items-center gap-1 mb-4">
                {[...Array(5)].map((_, i) => (
                  <svg key={i} className="w-5 h-5 text-amber-400 fill-current" viewBox="0 0 20 20">
                    <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z" />
                  </svg>
                ))}
              </div>
              <p className="text-slate-700 mb-6 leading-relaxed">
                "I compared multiple lenders and found the best rate here. The comparison tool saved me time and money. Professional service from start to finish."
              </p>
              <div className="flex items-center gap-3">
                <div className="w-12 h-12 bg-rose-100 rounded-full flex items-center justify-center">
                  <span className="text-rose-700 font-semibold text-lg">LG</span>
                </div>
                <div>
                  <p className="font-semibold text-slate-900">Lisa Garcia</p>
                  <p className="text-sm text-slate-500">Miami, FL</p>
                </div>
              </div>
            </div>

            {/* Testimonial 6 */}
            <div className="bg-white p-8 rounded-2xl shadow-lg border border-slate-100 hover:shadow-xl transition-shadow duration-300">
              <div className="flex items-center gap-1 mb-4">
                {[...Array(5)].map((_, i) => (
                  <svg key={i} className="w-5 h-5 text-amber-400 fill-current" viewBox="0 0 20 20">
                    <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z" />
                  </svg>
                ))}
              </div>
              <p className="text-slate-700 mb-6 leading-relaxed">
                "Straightforward and trustworthy. No surprises, no hidden fees. The repayment terms were flexible and worked perfectly with my budget. Would definitely use again."
              </p>
              <div className="flex items-center gap-3">
                <div className="w-12 h-12 bg-emerald-100 rounded-full flex items-center justify-center">
                  <span className="text-emerald-700 font-semibold text-lg">DW</span>
                </div>
                <div>
                  <p className="font-semibold text-slate-900">David Wilson</p>
                  <p className="text-sm text-slate-500">Chicago, IL</p>
                </div>
              </div>
            </div>
          </div>

          {/* Trust Stats */}
          <div className="mt-16 bg-gradient-to-r from-slate-50 to-slate-100 rounded-2xl p-8">
            <div className="grid md:grid-cols-4 gap-8 text-center">
              <div>
                <p className="text-4xl font-bold text-emerald-600 mb-2">50,000+</p>
                <p className="text-slate-600">Happy Customers</p>
              </div>
              <div>
                <p className="text-4xl font-bold text-emerald-600 mb-2">4.8/5</p>
                <p className="text-slate-600">Average Rating</p>
              </div>
              <div>
                <p className="text-4xl font-bold text-emerald-600 mb-2">$250M+</p>
                <p className="text-slate-600">Loans Funded</p>
              </div>
              <div>
                <p className="text-4xl font-bold text-emerald-600 mb-2">24/7</p>
                <p className="text-slate-600">Customer Support</p>
              </div>
            </div>
          </div>
        </div>

        {/* CTA Section */}
        <div className="mt-16 bg-slate-900 text-white rounded-2xl p-8 text-center">
          <h3 className="text-2xl font-bold mb-3">Fast Personal Loans When You Need Them</h3>
          <p className="text-slate-300 text-lg max-w-3xl mx-auto leading-relaxed">
            Life happens unexpectedly. Whether you're facing medical bills, home repairs, debt consolidation, or any other personal expense, our lending partners offer quick approval and flexible terms. Get the funds you need in days, not weeks, with transparent pricing and no hidden fees.
          </p>
        </div>
      </div>

      {/* Footer */}
      <footer className="bg-slate-900 text-slate-300 py-12">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="grid md:grid-cols-2 gap-8 mb-8">
            <div className="flex items-start gap-3">
              <svg className="w-6 h-6 text-emerald-400 mt-1 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z" />
              </svg>
              <div>
                <h4 className="font-semibold text-white mb-2">Secure & Private</h4>
                <p className="text-sm leading-relaxed">
                  Your information is protected with bank-level encryption. We never sell your personal data to third parties.
                </p>
              </div>
            </div>
            <div className="flex items-start gap-3">
              <svg className="w-6 h-6 text-emerald-400 mt-1 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
              </svg>
              <div>
                <h4 className="font-semibold text-white mb-2">Disclosure</h4>
                <p className="text-sm leading-relaxed">
                  We may receive compensation from featured partners. Rates and offers are subject to change. Always read terms and conditions before applying.
                </p>
              </div>
            </div>
          </div>
          <div className="border-t border-slate-800 pt-8 text-center text-sm text-slate-400">
            <p>© 2025 Financial Partners Network. All rights reserved.</p>
            <p className="mt-2">Not financial advice. Consult with a licensed professional for personalized guidance.</p>
          </div>
        </div>
      </footer>
    </div>
  );
}
